############################################################################
#####################        function define     ###########################
############################################################################
cccol <- c("#CE0013","#16557A","#C7A609","#87C232","#64C0AB","#A14C94","#15A08C","#8B7E75","#1E7CAF","#EA425F","#46489A","#E50033","#0F231F","#1187CD")

error.bar <- function(x, y, upper, lower=upper, length=0.05,...){
  if(length(x) != length(y) | length(y) !=length(lower) | length(lower) != length(upper))
    stop("vectors must be same length")
  arrows(x,y+upper, x, y-lower, angle=90, code=3, length=length, ...)
}

############################################################################
#########################      read in data       ##########################
############################################################################

avg_methyratio_tmp <- read.table("../data/RRBS_average_methylation_ratio.txt",header=T,row.names=1)
avg_methyratio <- avg_methyratio_tmp[,1]
names(avg_methyratio) <- row.names(avg_methyratio_tmp)
############################################################################
####################               plot            #########################
############################################################################

hiFT <- avg_methyratio["hiFT"]
he6 <- avg_methyratio["he6"]
n20 <- avg_methyratio["n20"]
n24 <- mean(avg_methyratio[c("n24_r1","n24_r2")])
niPS <- avg_methyratio["niPS"]
ICM <- mean(avg_methyratio[c("ICM1_r1","ICM1_r2","ICM2","ICM3")])
p20 <- mean(avg_methyratio[c("p20","p20_r2")])
p24 <- mean(avg_methyratio[c("p24","p24_r2")])
piPS <- avg_methyratio["piPS"]

hiFT_sd <- 0
he6_sd <- 0
n20_sd <- 0
n24_sd <-  sd(avg_methyratio[c("n24_r1","n24_r2")])
niPS_sd <- 0
ICM_sd <-  sd(avg_methyratio[c("ICM1_r1","ICM1_r2","ICM2","ICM3")])
p20_sd <-  sd(avg_methyratio[c("p20","p20_r2")])
p24_sd <-  sd(avg_methyratio[c("p24","p24_r2")])
piPS_sd <- 0

n_mean <- c(hiFT,he6,n20,n24,niPS,ICM)
n_sd <- c(hiFT_sd,he6_sd,n20_sd,n24_sd,niPS_sd,ICM_sd)
p_mean <- c(hiFT,he6,p20,p24,piPS,NA)
p_sd <- c(hiFT_sd,he6_sd,p20_sd,p24_sd,piPS_sd,NA)
plot_mean <- rbind(n_mean,p_mean)
plot_sd <- rbind(n_sd,p_sd)
plot_num <- rbind(c(1,1,1,1,1,4),c(1,1,2,2,1,4))

pdf("Fig5A.pdf",width=4,height=5)
cols <- c(rep(c(cccol[1],cccol[2]),5),cccol[8],cccol[8])
bp <- barplot(plot_mean,beside=T,names=c("hiFT-C","6d","20d","24d","iPSC-T","ICM"),col=cols,main="",ylim=c(0,0.8),las=2)
error.bar(bp,plot_mean, 1.96 * plot_sd / sqrt(plot_num),length=0.03)
legend("topright",c("naive","primed","ICM"),col=c(cccol[1:2],cccol[8]),pch=15,bty="n")
dev.off()

